require('dotenv').config();
const express = require("express");
const bodyParser = require("body-parser");
const app = express();
const PORT = process.env.PORT || 3000;

// ✅ Configurar EJS como motor de vistas
app.set('view engine', 'ejs');
app.set('views', './src/views');

// ✅ Parseo de formularios (para POST desde <form>)
app.use(express.urlencoded({ extended: true }));

// ✅ Conecta base de datos y sincroniza tablas
require('./models');

// ✅ Arranca el bot de Telegram
require('./bot/bot');

// ✅ Middleware para verificar firma de Stripe
app.use(
  bodyParser.json({
    verify: (req, res, buf) => {
      req.rawBody = buf;
    },
  })
);

const session = require('express-session');

app.use(session({
  secret: process.env.SESSION_SECRET || 'supersecret',
  resave: false,
  saveUninitialized: false
}));

// ✅ Webhook de Stripe
app.post("/webhook", require("./webhook"));

// ✅ Rutas del panel admin
app.use("/admin", require("./routes/admin"));

// ✅ Inicia el servidor
app.listen(PORT, () => {
  console.log(`🌐 Servidor escuchando en http://localhost:${PORT}`);
});
