require('dotenv').config();
const { Product } = require('../src/models');

const run = async () => {
  try {
    await Product.bulkCreate([
      {
        "name": "Windows 11 Pro License",
        "type": "license",
        "price": 5.00,
        "data": "W11-KEY-ABCD-1234"
    },
    {
        "name": "Canva Premium Invite",
        "type": "access",
        "price": 3.50,
        "data": "https://canva.com/invite-link"
    },
    {
        "name": "Mega Cloud Premium",
        "type": "account",
        "price": 4.00,
        "data": "Email: user@mega.com\nPassword: pass1234"
    }
    ]);

    console.log('✅ Productos insertados con éxito');
  } catch (err) {
    console.error('❌ Error insertando productos:', err);
  } finally {
    process.exit();
  }
};

run();
