// src/models/Product.js
module.exports = (sequelize, DataTypes) => {
  const Product = sequelize.define("Product", {
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    type: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    data: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    price: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    is_used: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    is_reserved: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    is_unlimited: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    }
  });

  // Método personalizado: contar stock disponible (solo si no es ilimitado)
  Product.prototype.getAvailableStock = async function () {
    if (this.is_unlimited) return '∞';

    const ProductStock = sequelize.models.ProductStock;
    const stock = await ProductStock.count({
      where: {
        product_id: this.id,
        is_used: false
      }
    });

    return stock;
  };

  return Product;
};
