// src/models/index.js
const sequelize = require('./db');
const { DataTypes } = require('sequelize');

// Instanciar modelos
const Product = require('./Product')(sequelize, DataTypes);
const PurchaseLog = require('./PurchaseLog')(sequelize, DataTypes);
const ProductStock = require('./ProductStock')(sequelize, DataTypes);
const ErrorLog = require('./ErrorLog')(sequelize, DataTypes);

// Asociaciones
Product.hasMany(ProductStock, { foreignKey: 'product_id' });
ProductStock.belongsTo(Product, { foreignKey: 'product_id' });

// Conexión DB
sequelize.authenticate()
  .then(() => console.log('✅ MySQL connected'))
  .catch(err => console.error('❌ DB Error:', err));

// Sincronizar
sequelize.sync({ alter: true })
  .then(() => console.log('✅ Tables synced'))
  .catch(err => console.error('❌ Sync error:', err));

// Exportar
module.exports = {
  sequelize,
  Product,
  PurchaseLog,
  ProductStock,
  ErrorLog
};
