const Stripe = require('stripe');
require('dotenv').config();

const stripe = new Stripe(process.env.STRIPE_SECRET_KEY);

async function createCheckoutSession(product, chatId) {
  const session = await stripe.checkout.sessions.create({
    payment_method_types: ['card'],
    mode: 'payment',
    line_items: [
      {
        price_data: {
          currency: 'usd',
          product_data: {
            name: product.name,
          },
          unit_amount: Math.round(product.price * 100),
        },
        quantity: 1,
      },
    ],
    success_url: 'https://t.me/DigitalKeysDiego_bot?start=success',
    cancel_url: 'https://t.me/DigitalKeysDiego_bot?start=cancel',
    metadata: {
      product_id: product.id,
      chat_id: chatId.toString()
    }
  });

  return session.url;
}


module.exports = { createCheckoutSession };
